<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>All Traders Due List</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 13pt;
            font-weight: 700;
            text-align: center;
            margin: 10px 0 5px 0;
            text-transform: uppercase;
            color: #1a1a1a;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table thead {
            background-color: #f5f5f5;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: left;
            font-weight: 600;
            font-size: 8pt;
        }
        
        table th:first-child {
            width: 40px;
        }
        
        table th:last-child {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 3px;
            font-size: 8pt;
        }
        
        table td:last-child {
            text-align: right;
        }
        
        .section-header {
            background-color: #e9ecef;
            font-weight: 700;
            font-size: 9pt;
        }
        
        .subtotal-row {
            background-color: #f8f9fa;
            font-weight: 600;
        }
        
        .category-subtotal-row {
            background-color: #fff3cd;
            font-weight: 600;
        }
        
        .payable-subtotal-row {
            background-color: #f8d7da;
            font-weight: 600;
        }
        
        .grand-total-row {
            background-color: #e9ecef;
            font-weight: 700;
            border-top: 2px double #000;
        }
        
        .grand-total-row td:last-child {
            border-top: 2px double #000;
        }
        
        .text-right {
            text-align: right;
        }
        
        .underline {
            text-decoration: underline;
        }
        
        .double-underline {
            border-bottom: 2px double #000;
        }
        
        /* Footer */
        .footer {
            margin-top: 15px;
            font-size: 8pt;
            text-align: center;
            color: #4a4a4a;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}{{ !empty($business->address_line_1) && !empty($business->city) ? ', ' : '' }}{{ $business->city ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city)) && !empty($business->state) ? ', ' : '' }}{{ $business->state ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city) || !empty($business->state)) && !empty($business->country) ? ', ' : '' }}{{ $business->country ?? '' }}</div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Phone: {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <br>Email: {{ $business->email }}
                    @endif
                </div>
            </div>
            <div class="header-right">
                <!-- Empty for alignment -->
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">All Traders Due List</div>
        <div class="report-date">Date of List: {{ $util->format_date($date, false) }}</div>
        
        <!-- Receivable Section (Customers) -->
        @if(count($customer_due_data) > 0)
            <table>
                <thead>
                    <tr class="section-header">
                        <th colspan="5">Receivable</th>
                    </tr>
                    <tr>
                        <th>SL</th>
                        <th>Customer Name</th>
                        <th>Address</th>
                        <th>Mobile</th>
                        <th>Due</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $serial = 1;
                    @endphp
                    @foreach($customer_due_data as $item)
                        <tr>
                            <td>{{ $serial++ }}</td>
                            <td>{{ $item->name }}</td>
                            <td>{{ $item->address }}</td>
                            <td>{{ $item->mobile }}</td>
                            <td>{{ $util->num_f($item->due_amount, true, null) }}</td>
                        </tr>
                    @endforeach
                    <tr class="subtotal-row">
                        <td colspan="4" style="text-align: right;">Group Wise Sub Total :</td>
                        <td>{{ $util->num_f($customer_total, true, null) }}</td>
                    </tr>
                    <tr class="category-subtotal-row">
                        <td colspan="4" style="text-align: right;">Category Wise SubTotal :</td>
                        <td>{{ $util->num_f($customer_total, true, null) }}</td>
                    </tr>
                </tbody>
            </table>
        @endif
        
        <!-- Payable Section (Suppliers) -->
        @if(count($supplier_due_data) > 0)
            <table style="margin-top: 15px;">
                <thead>
                    <tr class="section-header">
                        <th colspan="5">SUPPLIER</th>
                    </tr>
                    <tr>
                        <th>ID</th>
                        <th>Company/Trader Name</th>
                        <th>Address</th>
                        <th>Phone Number</th>
                        <th>Due Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($supplier_due_data as $item)
                        <tr>
                            <td>{{ $item->id }}</td>
                            <td>{{ $item->name }}</td>
                            <td>{{ $item->address }}</td>
                            <td>{{ $item->mobile }}</td>
                            <td>{{ $util->num_f($item->due_amount, true, null) }}</td>
                        </tr>
                    @endforeach
                    <tr class="subtotal-row">
                        <td colspan="4" style="text-align: right;">Group Wise Sub Total :</td>
                        <td>{{ $util->num_f($supplier_total, true, null) }}</td>
                    </tr>
                    <tr class="category-subtotal-row">
                        <td colspan="4" style="text-align: right;">Category Wise SubTotal :</td>
                        <td>{{ $util->num_f($supplier_total, true, null) }}</td>
                    </tr>
                    <tr class="payable-subtotal-row">
                        <td colspan="4" style="text-align: right;">Payable Sub Total :</td>
                        <td>{{ $util->num_f($supplier_total, true, null) }}</td>
                    </tr>
                </tbody>
            </table>
        @endif
        
        <!-- Grand Total -->
        <table style="margin-top: 15px;">
            <tbody>
                <tr class="grand-total-row">
                    <td colspan="4" style="text-align: right;">Grand Total :</td>
                    <td>{{ $util->num_f($grand_total, true, null) }}</td>
                </tr>
            </tbody>
        </table>
        
        <!-- Footer -->
        <div class="footer">
            <div>Print Date & Time: {{ date('d/m/Y h:i:sA') }}</div>
            <div>Page: <span class="page-number"></span></div>
        </div>
    </div>
    
    <script type="text/php">
        if (isset($pdf)) {
            $text = "Page {PAGE_NUM} of {PAGE_COUNT}";
            $size = 8;
            $font = $fontMetrics->getFont("Arial");
            $width = $fontMetrics->get_text_width($text, $font, $size) / 2;
            $x = ($pdf->get_width() - $width) / 2;
            $y = $pdf->get_height() - 30;
            $pdf->page_text($x, $y, $text, $font, $size);
        }
    </script>
</body>
</html>

