<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Cash Book</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: left;
            padding-left: 10px;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #000;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #000;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 5px 0;
            text-transform: uppercase;
            color: #000;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #000;
        }
        
        .account-name {
            font-size: 9pt;
            text-align: left;
            margin-bottom: 8px;
            color: #000;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table thead {
            background-color: transparent;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: 700;
            font-size: 8pt;
            background-color: transparent;
        }
        
        table th:nth-child(1),
        table th:nth-child(2),
        table th:nth-child(3),
        table th:nth-child(4),
        table th:nth-child(5),
        table th:nth-child(6),
        table th:nth-child(7) {
            text-align: left;
        }
        
        table th:nth-child(8),
        table th:nth-child(9),
        table th:nth-child(10) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 4px 3px;
            font-size: 8pt;
        }
        
        table td:nth-child(1),
        table td:nth-child(2),
        table td:nth-child(3),
        table td:nth-child(4),
        table td:nth-child(5),
        table td:nth-child(6),
        table td:nth-child(7) {
            text-align: left;
        }
        
        table td:nth-child(8),
        table td:nth-child(9),
        table td:nth-child(10) {
            text-align: right;
        }
        
        tfoot tr {
            background-color: #f0f0f0;
            font-weight: 700;
        }
        
        tfoot tr:last-child {
            background-color: #e0e0e0;
        }
        
        .no-data {
            text-align: center;
            padding: 20px;
            font-size: 10pt;
            color: #666;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ asset('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name }}</div>
                <div class="company-address">
                    @if(!empty($business->landmark))
                        {{ $business->landmark }},
                    @endif
                    @if(!empty($business->city))
                        {{ $business->city }},
                    @endif
                    @if(!empty($business->state))
                        {{ $business->state }}
                    @endif
                </div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        Phone: {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        Email: {{ $business->email }}
                    @endif
                </div>
            </div>
            <div class="header-right">
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Cash Book</div>
        
        <!-- Date Range -->
        <div class="report-date">
            {{ \Carbon\Carbon::parse($start_date)->format('d/m/Y') }} To {{ \Carbon\Carbon::parse($end_date)->format('d/m/Y') }}
        </div>
        
        <!-- Account Name -->
        @if(!empty($account))
            <div class="account-name"><strong>Accounts Name:</strong> {{ $account->name }}</div>
        @elseif(!empty($show_all_accounts) && $show_all_accounts)
            <div class="account-name"><strong>Accounts Name:</strong> All Accounts</div>
        @endif
        
        <!-- Warning if Account module not enabled -->
        @if(empty($account_module_enabled))
            <div class="no-data" style="background-color: #fff3cd; border: 1px solid #ffc107; padding: 15px; margin: 10px 0;">
                <strong>Warning:</strong> This report works only if the Account module is enabled. 
                Please enable the Account module from Business Settings → Modules.
            </div>
        @endif
        
        <!-- Table -->
        @if((!empty($account) || (!empty($show_all_accounts) && $show_all_accounts)) && count($ledger_data) > 0 && !empty($account_module_enabled))
            <table>
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Transaction Mode</th>
                        <th>A/C Name</th>
                        <th>Narration</th>
                        <th>Ref No.</th>
                        <th>Voucher No</th>
                        <th>Debit</th>
                        <th>Credit</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($ledger_data as $item)
                        <tr>
                            <td>{{ $util->format_date($item->date, false) }}</td>
                            <td>{{ $item->type }}</td>
                            <td>{{ $item->transaction_mode }}</td>
                            <td>{{ $item->ac_name }}</td>
                            <td>{{ $item->narration }}</td>
                            <td>{{ $item->ref_no }}</td>
                            <td>{{ $item->voucher_no }}</td>
                            <td>{{ $util->num_f($item->debit, true, null) }}</td>
                            <td>{{ $util->num_f($item->credit, true, null) }}</td>
                            <td>{{ $util->num_f($item->balance, true, null) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="7" style="text-align: right;"><strong>Grand Total :</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_debit ?? 0, true, null) }}</strong></td>
                        <td><strong>{{ $util->num_f($grand_total_credit ?? 0, true, null) }}</strong></td>
                        <td></td>
                    </tr>
                    <tr>
                        <td colspan="9" style="text-align: right;"><strong>Closing Balance:</strong></td>
                        <td><strong>{{ $util->num_f($closing_balance ?? 0, true, null) }}</strong></td>
                    </tr>
                </tfoot>
            </table>
        @else
            <div class="no-data">
                @if(empty($account_module_enabled))
                    <strong>Warning:</strong> This report works only if the Account module is enabled. 
                    Please enable the Account module from Business Settings → Modules.
                @elseif(empty($account))
                    Please select an account to view the cash book.
                @else
                    No transactions found for the selected account and date range.
                @endif
            </div>
        @endif
    </div>
</body>
</html>

