<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Accounts Payable</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: left;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
            text-align: left;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
            text-align: left;
        }
        
        .company-contact strong {
            font-weight: 700;
        }
        
        .report-title {
            font-size: 13pt;
            font-weight: 700;
            text-align: center;
            margin: 10px 0 5px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #1a1a1a;
            font-weight: 700;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table th {
            border: 1px solid #000;
            padding: 6px 4px;
            text-align: center;
            font-weight: 700;
            font-size: 8pt;
            background-color: #f5f5f5;
        }
        
        table th:first-child {
            width: 50px;
        }
        
        table th:nth-child(2),
        table th:nth-child(3),
        table th:nth-child(4),
        table th:nth-child(5) {
            text-align: left;
        }
        
        table th:last-child {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 4px;
            font-size: 8pt;
        }
        
        table td:first-child {
            text-align: center;
        }
        
        table td:nth-child(2),
        table td:nth-child(3),
        table td:nth-child(4),
        table td:nth-child(5) {
            text-align: left;
        }
        
        table td:last-child {
            text-align: right;
        }
        
        .total-row {
            font-weight: 700;
            border-top: 2px double #000;
            background-color: #f8f9fa;
        }
        
        .total-row td:last-child {
            border-top: 2px double #000;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}{{ !empty($business->address_line_1) && !empty($business->city) ? ', ' : '' }}{{ $business->city ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city)) && !empty($business->state) ? ', ' : '' }}{{ $business->state ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city) || !empty($business->state)) && !empty($business->country) ? ', ' : '' }}{{ $business->country ?? '' }}</div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        <strong>Phone</strong> {{ $business->mobile }}
                    @endif
                    @if(!empty($business->fax))
                        <strong>Fax</strong> {{ $business->fax }}
                    @endif
                    @if(!empty($business->email))
                        <strong>Email</strong> {{ $business->email }}
                    @endif
                    @if(!empty($business->website))
                        {{ $business->website }}
                    @endif
                </div>
            </div>
            <div class="header-right">
                <!-- Empty for alignment -->
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Accounts Payable</div>
        <div class="report-date">{{ $util->format_date($end_date, false) }}</div>
        
        <!-- Payable Table -->
        <table>
            <thead>
                <tr>
                    <th>SL</th>
                    <th>Accounts Name</th>
                    <th>Proprietor</th>
                    <th>Address</th>
                    <th>Mobile</th>
                    <th>Balance</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $serial = 1;
                @endphp
                @foreach($payable_data as $supplier)
                    <tr>
                        <td>{{ $serial++ }}</td>
                        <td>{{ $supplier->accounts_name }}</td>
                        <td>{{ $supplier->proprietor }}</td>
                        <td>{{ $supplier->address }}</td>
                        <td>{{ $supplier->mobile }}</td>
                        <td>{{ $util->num_f($supplier->balance, true, null) }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr class="total-row">
                    <td colspan="5" style="text-align: right;">Grand Total</td>
                    <td>{{ $util->num_f($grand_total, true, null) }}</td>
                </tr>
            </tfoot>
        </table>
    </div>
</body>
</html>

