@extends('layouts.app')
@section('title', __('businessmanagement::lang.accounts_register'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header" style="background: linear-gradient(135deg, #6f42c1 0%, #5a32a3 100%); padding: 30px 20px; margin: -20px -15px 30px -15px; border-radius: 0;">
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-md-12 text-center">
                <h1 style="color: #fff; font-size: 32px; font-weight: 700; margin: 0; display: flex; align-items: center; justify-content: center; gap: 15px;">
                    <i class="fa fa-book" style="font-size: 36px;"></i>
                    Accounts Register Reports
                </h1>
                <p style="color: rgba(255,255,255,0.9); font-size: 16px; margin: 10px 0 0 0;">
                    Comprehensive accounts and financial analysis reports
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row" style="display: flex; flex-wrap: wrap; margin: 0 -15px;">
            <!-- Due List Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="6f42c1">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-file-invoice-dollar"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>Due List</h3>
                        <p>Comprehensive due list report showing outstanding balances for customers and suppliers, grouped by category.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-users"></i>
                                <span>{{ __('businessmanagement::lang.customer_supplier_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueList']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- All Customers Due List Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="17a2b8">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-users"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.popular') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>All Customers Due List</h3>
                        <p>Detailed list of all customers with their outstanding balances, including contact information and receivable amounts.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-user"></i>
                                <span>{{ __('businessmanagement::lang.customer_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'allCustomersDueList']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Supplier Due List Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="fd7e14">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-file-invoice"></i>
                        </div>
                        <div class="card-badge">Featured</div>
                    </div>
                    <div class="card-body-section">
                        <h3>Supplier Due List</h3>
                        <p>Detailed list of all suppliers with their outstanding balances (payables), including contact information and amounts owed.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-truck"></i>
                                <span>{{ __('businessmanagement::lang.supplier_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'supplierDueList']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Accounts Ledger Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="28a745">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-book-open"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>Accounts Ledger</h3>
                        <p>Detailed ledger report showing all transactions for customers and suppliers with running balance, including sales, purchases, payments, and returns.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-users"></i>
                                <span>{{ __('businessmanagement::lang.customer_supplier_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerAccountsLedger']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Cash Book Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="17a2b8">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-money-bill-wave"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>Cash Book</h3>
                        <p>Detailed cash book report showing all account transactions with running balance, including sales, purchases, payments, and receipts.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-university"></i>
                                <span>{{ __('businessmanagement::lang.account_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashBook']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Credit Voucher Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="ffc107">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-file-invoice-dollar"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.date_wise_credit_voucher') }}</h3>
                        <p>Detailed credit voucher report showing all money receipts (credit transactions) for a specific date range with voucher details.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-file-alt"></i>
                                <span>Voucher Details</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseCreditVoucher']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Debit Voucher Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="dc3545">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-file-invoice-dollar"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.date_wise_debit_voucher') }}</h3>
                        <p>Detailed debit voucher report showing all money payments (debit transactions) for a specific date range, separated into Supplier/Customer Payment and General A/C Payment sections.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-file-alt"></i>
                                <span>Payment Details</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseDebitVoucher']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Income Statement Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="28a745">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-chart-line"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.income_statement') }}</h3>
                        <p>Comprehensive income statement report showing revenue, cost of goods sold, expenses, and net profit for a specific date range with location filtering.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-chart-bar"></i>
                                <span>{{ __('businessmanagement::lang.revenue_expenses') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'incomeStatement']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Day Book Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="6f42c1">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-book-open"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>Day Book</h3>
                        <p>Comprehensive day book report showing all daily transactions including credit vouchers, debit vouchers, purchases, sales, and sales returns with debit/credit amounts.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-filter"></i>
                                <span>{{ __('businessmanagement::lang.transaction_type_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dayBook']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Due List Without Treatment Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="28a745">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-file-invoice"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>Due List Without Treatment</h3>
                        <p>Comprehensive due list report showing outstanding balances for customers (receivable) and suppliers (payable) with contact information and due amounts.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-users"></i>
                                <span>{{ __('businessmanagement::lang.supplier_filter_all_single') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-user"></i>
                                <span>{{ __('businessmanagement::lang.customer_filter_all_single') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dueListWithoutTreatment']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Sales Received Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="007bff">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-chart-line"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.date_wise_sales_received') }}</h3>
                        <p>Comprehensive sales received report showing opening due, sales, discount, received amounts, sales due, and current due categorized by Supplier, Retailer, Dealer, Credit Customer, and Cash.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-users"></i>
                                <span>Category Wise Breakdown</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseSalesReceived']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Balance Sheet Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="20c997">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-balance-scale"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>Balance Sheet</h3>
                        <p>Comprehensive balance sheet report showing assets and liabilities with detailed breakdown including capital accounts, current liabilities, sundry creditor/debtor, stock accounts, investments, and profit/loss.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-columns"></i>
                                <span>Two Column Layout</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'balanceSheet']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise General Expenses Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="e83e8c">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-file-invoice-dollar"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.date_wise_general_expenses') }}</h3>
                        <p>Detailed expense report showing all general expenses grouped by category with date range, category, and location filters. Includes account ledger names and amounts.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-tags"></i>
                                <span>Category Filter</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseGeneralExpenses']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Accounts Receivable Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="6c757d">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-hand-holding-usd"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.accounts_receivable') }}</h3>
                        <p>Comprehensive accounts receivable report showing all customers with outstanding balances. Includes customer details, addresses, mobile numbers, and receivable amounts as of a specific date.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-users"></i>
                                <span>{{ __('businessmanagement::lang.customer_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'accountsReceivable']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Accounts Payable Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="495057">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-file-invoice"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.accounts_payable') }}</h3>
                        <p>Comprehensive accounts payable report showing all suppliers with outstanding balances. Includes supplier details, addresses, mobile numbers, and payable amounts as of a specific date.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-truck"></i>
                                <span>{{ __('businessmanagement::lang.supplier_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'accountsPayable']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Customer Due With Ageing Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="343a40">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-clock"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.customer_due_with_ageing') }}</h3>
                        <p>Comprehensive customer due report with aging analysis showing last sales date, last receipt date, days since transactions, and current outstanding balances grouped by customer categories.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-users"></i>
                                <span>{{ __('businessmanagement::lang.customer_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'customerDueWithAgeing']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Cash Flows Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="0d6efd">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-money-bill-wave"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.cash_flows') }}</h3>
                        <p>Comprehensive statement of cash flows showing all cash receipts (revenue) and cash payments (expenses) grouped by cash accounts for a specific date range.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-print"></i>
                                <span>{{ __('businessmanagement::lang.print_preview') }}</span>
                    </div>
                </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashFlows']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                    </div>
                </div>
            
            <!-- Date Wise Receipt Payment Statement Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="198754">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-exchange-alt"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.date_wise_receipt_payment_statement') }}</h3>
                        <p>Comprehensive receipt and payment statement showing opening balance, receipts by account, payments by category with sub-items, and closing balance for cash and bank accounts.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-hand-holding-usd"></i>
                                <span>{{ __('businessmanagement::lang.receipt_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-file-invoice-dollar"></i>
                                <span>{{ __('businessmanagement::lang.payment_filter') }}</span>
                    </div>
                </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceiptPaymentStatement']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                        </div>
                    </div>
                </div>
            
            <!-- Date Wise Receive Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="17a2b8">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-hand-holding-usd"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.date_wise_receive') }}</h3>
                        <p>Detailed cash receipt report showing all customer and supplier cash receipts with receive ID, received from, narration, reference number, prepared by, and amount details.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-money-bill-wave"></i>
                                <span>{{ __('businessmanagement::lang.cash_receipts_only') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseReceive']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
            
            <!-- Date Wise Sales with Profit Report Card -->
            <div class="col-md-4" style="padding: 0 15px; margin-bottom: 30px; display: flex;">
                <div class="account-report-card" data-color="fd7e14">
                    <div class="card-header-section">
                        <div class="icon-circle">
                            <i class="fa fa-chart-line"></i>
                        </div>
                        <div class="card-badge">{{ __('businessmanagement::lang.new') }}</div>
                    </div>
                    <div class="card-body-section">
                        <h3>{{ __('businessmanagement::lang.date_wise_sales_with_profit') }}</h3>
                        <p>Comprehensive date-wise sales report showing sales amount, cost amount, expenses, income, and profit for each date in the selected range with grand totals.</p>
                        <div class="features-list">
                            <div class="feature-item">
                                <i class="fa fa-calendar"></i>
                                <span>{{ __('businessmanagement::lang.date_range_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-map-marker-alt"></i>
                                <span>{{ __('businessmanagement::lang.location_filter') }}</span>
                            </div>
                            <div class="feature-item">
                                <i class="fa fa-calculator"></i>
                                <span>{{ __('businessmanagement::lang.profit_calculation') }}</span>
                            </div>
                        </div>
                        <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseSalesWithProfit']) }}" class="action-button">
                            <span>{{ __('businessmanagement::lang.view_report') }}</span>
                            <i class="fa fa-arrow-right"></i>
                        </a>
                    </div>
                    <div class="card-footer-section">
                        <span class="status-badge success">
                            <i class="fa fa-check"></i>
                            {{ __('businessmanagement::lang.active') }}
                        </span>
                        <span class="version-badge">v1.0.0</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .account-report-card {
        background: #ffffff;
        border-radius: 16px;
        margin-bottom: 0;
        overflow: hidden;
        position: relative;
        height: 100%;
        width: 100%;
        display: flex;
        flex-direction: column;
        border: 2px solid #f1f5f9;
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
    }

    .account-report-card::after {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 5px;
        background: linear-gradient(90deg, var(--card-color), var(--card-color-light));
        transform: scaleX(0);
        transform-origin: left;
        transition: transform 0.4s ease;
    }

    .account-report-card[data-color="6f42c1"] {
        --card-color: #6f42c1;
        --card-color-light: #9d6de8;
        --card-color-bg: rgba(111, 66, 193, 0.08);
    }

    .account-report-card[data-color="17a2b8"] {
        --card-color: #17a2b8;
        --card-color-light: #4fc3dc;
        --card-color-bg: rgba(23, 162, 184, 0.08);
    }

    .account-report-card[data-color="fd7e14"] {
        --card-color: #fd7e14;
        --card-color-light: #ff9f4d;
        --card-color-bg: rgba(253, 126, 20, 0.08);
    }

    .account-report-card[data-color="28a745"] {
        --card-color: #28a745;
        --card-color-light: #5cb85c;
        --card-color-bg: rgba(40, 167, 69, 0.08);
    }

    .account-report-card[data-color="ffc107"] {
        --card-color: #ffc107;
        --card-color-light: #ffd54f;
        --card-color-bg: rgba(255, 193, 7, 0.08);
    }

    .account-report-card[data-color="dc3545"] {
        --card-color: #dc3545;
        --card-color-light: #e4606d;
        --card-color-bg: rgba(220, 53, 69, 0.08);
    }

    .account-report-card[data-color="007bff"] {
        --card-color: #007bff;
        --card-color-light: #4da3ff;
        --card-color-bg: rgba(0, 123, 255, 0.08);
    }

    .account-report-card[data-color="20c997"] {
        --card-color: #20c997;
        --card-color-light: #4dd4ac;
        --card-color-bg: rgba(32, 201, 151, 0.08);
    }

    .account-report-card[data-color="e83e8c"] {
        --card-color: #e83e8c;
        --card-color-light: #f8a5c2;
        --card-color-bg: rgba(232, 62, 140, 0.08);
    }

    .account-report-card[data-color="6c757d"] {
        --card-color: #6c757d;
        --card-color-light: #adb5bd;
        --card-color-bg: rgba(108, 117, 125, 0.08);
    }

    .account-report-card[data-color="495057"] {
        --card-color: #495057;
        --card-color-light: #868e96;
        --card-color-bg: rgba(73, 80, 87, 0.08);
    }

    .account-report-card[data-color="343a40"] {
        --card-color: #343a40;
        --card-color-light: #6c757d;
        --card-color-bg: rgba(52, 58, 64, 0.08);
    }

    .account-report-card[data-color="0d6efd"] {
        --card-color: #0d6efd;
        --card-color-light: #4da3ff;
        --card-color-bg: rgba(13, 110, 253, 0.08);
    }

    .account-report-card[data-color="198754"] {
        --card-color: #198754;
        --card-color-light: #4caf50;
        --card-color-bg: rgba(25, 135, 84, 0.08);
    }

    .account-report-card:hover {
        transform: translateY(-12px) scale(1.02);
        border-color: var(--card-color);
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.12), 0 8px 16px rgba(0, 0, 0, 0.08);
    }

    .account-report-card:hover::after {
        transform: scaleX(1);
    }

    .card-header-section {
        position: relative;
        padding: 30px 30px 20px;
        background: linear-gradient(135deg, var(--card-color-bg), transparent);
    }

    .icon-circle {
        width: 80px;
        height: 80px;
        background: linear-gradient(135deg, var(--card-color), var(--card-color-light));
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        position: relative;
        transition: all 0.4s ease;
    }

    .account-report-card:hover .icon-circle {
        transform: rotate(-10deg) scale(1.1);
        box-shadow: 0 12px 30px rgba(0, 0, 0, 0.2);
    }

    .icon-circle::before {
        content: '';
        position: absolute;
        inset: -3px;
        border-radius: 20px;
        padding: 3px;
        background: linear-gradient(135deg, var(--card-color), var(--card-color-light));
        -webkit-mask: linear-gradient(#fff 0 0) content-box, linear-gradient(#fff 0 0);
        -webkit-mask-composite: xor;
        mask-composite: exclude;
        opacity: 0;
        transition: opacity 0.4s ease;
    }

    .account-report-card:hover .icon-circle::before {
        opacity: 1;
    }

    .icon-circle i {
        color: #fff;
        font-size: 36px;
        position: relative;
        z-index: 1;
    }

    .card-badge {
        position: absolute;
        top: 20px;
        right: 20px;
        background: var(--card-color);
        color: #fff;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .card-body-section {
        padding: 0 30px 25px;
        flex: 1;
        display: flex;
        flex-direction: column;
    }

    .card-body-section h3 {
        margin: 0 0 12px 0;
        font-size: 24px;
        font-weight: 700;
        color: #1e293b;
        line-height: 1.2;
    }

    .card-body-section p {
        color: #64748b;
        font-size: 14px;
        line-height: 1.7;
        margin-bottom: 24px;
        flex: 1;
    }

    .features-list {
        display: flex;
        flex-direction: row;
        flex-wrap: wrap;
        gap: 10px;
        margin-bottom: 25px;
        padding: 15px 20px;
        background: #f8fafc;
        border-radius: 12px;
        border-left: 4px solid var(--card-color);
        align-items: center;
        justify-content: flex-start;
    }

    .feature-item {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #475569;
        font-size: 13px;
        font-weight: 500;
        white-space: nowrap;
    }

    .feature-item i {
        color: var(--card-color);
        font-size: 16px;
        width: 20px;
        text-align: center;
    }

    .action-button {
        display: flex;
        align-items: center;
        justify-content: space-between;
        background: linear-gradient(135deg, var(--card-color), var(--card-color-light));
        color: #fff;
        padding: 16px 24px;
        border-radius: 12px;
        text-decoration: none;
        font-weight: 600;
        font-size: 15px;
        transition: all 0.3s ease;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        position: relative;
        overflow: hidden;
    }

    .action-button::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
        transition: left 0.5s ease;
    }

    .action-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        color: #fff;
        text-decoration: none;
    }

    .action-button:hover::before {
        left: 100%;
    }

    .action-button span {
        position: relative;
        z-index: 1;
    }

    .action-button i {
        position: relative;
        z-index: 1;
        transition: transform 0.3s ease;
    }

    .action-button:hover i {
        transform: translateX(5px);
    }

    .card-footer-section {
        padding: 20px 30px;
        background: #f8fafc;
        border-top: 1px solid #e2e8f0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .status-badge {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .status-badge.success {
        background: #d1fae5;
        color: #065f46;
    }

    .status-badge i {
        font-size: 10px;
    }

    .version-badge {
        background: #fee2e2;
        color: #991b1b;
        padding: 6px 14px;
        border-radius: 20px;
        font-size: 11px;
        font-weight: 700;
    }

    @media (max-width: 768px) {
        .account-report-card {
            margin-bottom: 0;
        }
        
        .col-md-4 {
            margin-bottom: 20px !important;
        }

        .card-header-section,
        .card-body-section,
        .card-footer-section {
            padding-left: 20px;
            padding-right: 20px;
        }

        .icon-circle {
            width: 70px;
            height: 70px;
        }

        .icon-circle i {
            font-size: 30px;
        }

        .card-body-section h3 {
            font-size: 20px;
        }

        .features-list {
            flex-direction: column;
            align-items: flex-start;
        }

        .feature-item {
            width: 100%;
        }
    }
</style>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Add any JavaScript here when reports are added
    });
</script>
@endsection
