@extends('layouts.app')
@section('title', __('businessmanagement::lang.income_statement'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.income_statement') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'incomeStatement']), 'method' => 'get', 'id' => 'income_statement_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'income_statement_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'income_statement_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'incomeStatement']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printIncomeStatement'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'location_id' => $location_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    <table class="table table-bordered" style="font-size: 12px; width: 100%;">
                        <thead>
                            <tr>
                                <th style="text-align: left; width: 60%;">A/C Ledger Name</th>
                                <th style="text-align: right; width: 40%;">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Revenue Section -->
                            <tr>
                                <td><strong>Sales Accounts</strong></td>
                                <td style="text-align: right;">{{ $util->num_f($sales_accounts, true, null) }}</td>
                            </tr>
                            <tr>
                                <td>Cost of Goods Sold</td>
                                <td style="text-align: right;">{{ $util->num_f($cost_of_goods_sold, true, null) }}</td>
                            </tr>
                            <tr>
                                <td>Sales Return A/C</td>
                                <td style="text-align: right;">{{ $util->num_f($sales_return, true, null) }}</td>
                            </tr>
                            <tr>
                                <td>Cost Of Goods Sales Return</td>
                                <td style="text-align: right;">{{ $util->num_f($cost_of_goods_sales_return, true, null) }}</td>
                            </tr>
                            <tr>
                                <td>Extracharges On Sales</td>
                                <td style="text-align: right;">{{ $util->num_f($extracharges_on_sales, true, null) }}</td>
                            </tr>
                            <tr>
                                <td>Extracharges On Purchase</td>
                                <td style="text-align: right;">{{ $util->num_f($extracharges_on_purchase, true, null) }}</td>
                            </tr>
                            <tr>
                                <td>Discount on Sales</td>
                                <td style="text-align: right;">{{ $util->num_f($discount_on_sales, true, null) }}</td>
                            </tr>
                            <tr style="border-top: 1px solid #000;">
                                <td><strong>Gross Profit</strong></td>
                                <td style="text-align: right; border-top: 1px solid #000;"><strong>{{ $util->num_f($gross_profit, true, null) }}</strong></td>
                            </tr>
                            
                            <!-- Expenses Section -->
                            @if(count($expenses_by_category) > 0)
                                @foreach($expenses_by_category as $category)
                                    <tr>
                                        <td colspan="2" style="padding-top: 15px;"><strong>{{ $category['category_name'] }}:</strong></td>
                                    </tr>
                                    @foreach($category['items'] as $item)
                                        <tr>
                                            <td style="padding-left: 30px;">{{ $item['name'] }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($item['amount'], true, null) }}</td>
                                        </tr>
                                    @endforeach
                                    <tr style="border-top: 1px solid #000;">
                                        <td><strong>Expense Sub Total</strong></td>
                                        <td style="text-align: right; border-top: 1px solid #000;"><strong>{{ $util->num_f($category['sub_total'], true, null) }}</strong></td>
                                    </tr>
                                @endforeach
                            @endif
                            
                            <!-- Total Expense -->
                            <tr style="border-top: 2px double #000;">
                                <td><strong>Total Expense</strong></td>
                                <td style="text-align: right; border-top: 2px double #000;"><strong>{{ $util->num_f($total_expense, true, null) }}</strong></td>
                            </tr>
                            
                            <!-- Net Profit -->
                            <tr style="border-top: 2px double #000;">
                                <td><strong>Current Period</strong></td>
                                <td style="text-align: right; border-top: 2px double #000;"></td>
                            </tr>
                            <tr>
                                <td style="padding-left: 30px;"><strong>Profit A/C</strong></td>
                                <td style="text-align: right;"><strong>{{ $util->num_f($net_profit, true, null) }}</strong></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#income_statement_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#income_statement_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#income_statement_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#income_statement_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#income_statement_filter_form').on('submit', function() {
            var start_date_val = $('#income_statement_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#income_statement_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

