@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_credit_voucher'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_credit_voucher') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseCreditVoucher']), 'method' => 'get', 'id' => 'date_wise_credit_voucher_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'date_wise_credit_voucher_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'date_wise_credit_voucher_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'dateWiseCreditVoucher']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($account_module_enabled) && count($vouchers) > 0)
                                <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printDateWiseCreditVoucher'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'location_id' => $location_id ?? '']) }}" 
                                   target="_blank" 
                                   class="btn btn-success">
                                    <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @if(empty($account_module_enabled))
                <div class="alert alert-warning" style="margin-bottom: 20px;">
                    <i class="fa fa-exclamation-triangle"></i> 
                    <strong>Warning:</strong> This report works only if the Account module is enabled. 
                    Please enable the Account module from <a href="{{ url('/business/settings') }}" target="_blank">Business Settings</a> → Modules.
                </div>
            @endif
            @component('components.widget', ['class' => 'box-primary'])
                @if(!empty($account_module_enabled) && count($vouchers) > 0)
                    <div class="table-responsive" style="overflow-x: auto;">
                        <table class="table table-bordered table-striped" style="font-size: 12px;">
                            <thead>
                                <tr>
                                    <th style="text-align: center;">SL</th>
                                    <th style="text-align: left;">Date</th>
                                    <th style="text-align: left;">Voucher ID</th>
                                    <th style="text-align: left;">Particulars</th>
                                    <th style="text-align: left;">Ref No.</th>
                                    <th style="text-align: left;">Entered By</th>
                                    <th style="text-align: left;">Bank Name & A/C No.</th>
                                    <th style="text-align: left;">Cheque No</th>
                                    <th style="text-align: left;">Chq. Date</th>
                                    <th style="text-align: right;">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($vouchers as $index => $voucher)
                                    <tr>
                                        <td style="text-align: center;">{{ $index + 1 }}</td>
                                        <td>{{ $util->format_date($voucher->operation_date, false) }}</td>
                                        <td>{{ $voucher->voucher_id }}</td>
                                        <td>{{ $voucher->particulars }}</td>
                                        <td>{{ $voucher->ref_no ?? '' }}</td>
                                        <td>{{ $voucher->entered_by }}</td>
                                        <td>{{ $voucher->bank_name_account }}</td>
                                        <td>{{ $voucher->cheque_number ?? '' }}</td>
                                        <td>{{ $voucher->cheque_date ? $util->format_date($voucher->cheque_date, false) : '' }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($voucher->amount, true, null) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr style="background-color: #f8f9fa; font-weight: bold;">
                                    <td colspan="9" style="text-align: right;"><strong>Sub Total:</strong></td>
                                    <td style="text-align: right;"><strong>{{ $util->num_f($total_amount, true, null) }}</strong></td>
                                </tr>
                                <tr style="background-color: #e9ecef; font-weight: bold;">
                                    <td colspan="9" style="text-align: right;"><strong>Total:</strong></td>
                                    <td style="text-align: right; border-top: 2px double #000;"><strong>{{ $util->num_f($total_amount, true, null) }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                @elseif(empty($account_module_enabled))
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i> 
                        <strong>Account Module Not Enabled:</strong> This report works only if the Account module is enabled. 
                        Please enable the Account module from <a href="{{ url('/business/settings') }}" target="_blank">Business Settings</a> → Modules.
                    </div>
                @else
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> No credit vouchers found for the selected date range.
                    </div>
                @endif
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#date_wise_credit_voucher_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#date_wise_credit_voucher_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#date_wise_credit_voucher_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#date_wise_credit_voucher_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#date_wise_credit_voucher_filter_form').on('submit', function() {
            var start_date_val = $('#date_wise_credit_voucher_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#date_wise_credit_voucher_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

