@extends('layouts.app')
@section('title', __('businessmanagement::lang.cash_flows'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.cash_flows') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashFlows']), 'method' => 'get', 'id' => 'cash_flows_filter_form' ]) !!}
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->startOfMonth()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'cash_flows_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? \Carbon\Carbon::now()->startOfMonth()->format('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'cash_flows_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'cashFlows']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printCashFlows'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : \Carbon\Carbon::now()->startOfMonth()->format('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'location_id' => $location_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    <table class="table table-bordered table-striped" style="font-size: 12px;">
                        <thead>
                            <tr>
                                <th style="text-align: left; width: 40%;">Particulars</th>
                                <th style="text-align: right; width: 30%;">Amount in Tk.</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Revenue Section -->
                            <tr style="background-color: #f5f5f5; font-weight: bold;">
                                <td>Revenue</td>
                                <td style="text-align: right;">{{ $util->num_f($total_revenue_period2 ?? 0, true, null) }}</td>
                            </tr>
                            <tr style="background-color: #f8f9fa; font-weight: bold;">
                                <td style="padding-left: 20px;">Cash</td>
                                <td></td>
                            </tr>
                            @if(!empty($all_revenue_accounts) && count($all_revenue_accounts) > 0)
                                @foreach($all_revenue_accounts as $account)
                                    @php
                                        $amount = $revenue_data_period2[$account] ?? 0;
                                    @endphp
                                    @if($amount > 0)
                                        <tr>
                                            <td style="padding-left: 40px;">{{ $account }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($amount, true, null) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            @else
                                <tr>
                                    <td style="padding-left: 40px;">Cash</td>
                                    <td style="text-align: right;">0.00</td>
                                </tr>
                            @endif
                            <tr style="font-weight: bold; border-top: 1px solid #000;">
                                <td style="text-align: right;">Tk.</td>
                                <td style="text-align: right; border-top: 1px solid #000;">{{ $util->num_f($total_revenue_period2 ?? 0, true, null) }}</td>
                            </tr>
                            
                            <!-- Expenses Section -->
                            <tr style="background-color: #f5f5f5; font-weight: bold;">
                                <td>Expenses</td>
                                <td style="text-align: right;">{{ $util->num_f($total_expenses_period2 ?? 0, true, null) }}</td>
                            </tr>
                            <tr style="background-color: #f8f9fa; font-weight: bold;">
                                <td style="padding-left: 20px;">Cash</td>
                                <td></td>
                            </tr>
                            @if(!empty($all_expense_accounts) && count($all_expense_accounts) > 0)
                                @foreach($all_expense_accounts as $account)
                                    @php
                                        $amount = $expenses_data_period2[$account] ?? 0;
                                    @endphp
                                    @if($amount > 0)
                                        <tr>
                                            <td style="padding-left: 40px;">{{ $account }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($amount, true, null) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            @else
                                <tr>
                                    <td style="padding-left: 40px;">Cash</td>
                                    <td style="text-align: right;">0.00</td>
                                </tr>
                            @endif
                            <tr style="font-weight: bold; border-top: 1px solid #000;">
                                <td style="text-align: right;">Tk.</td>
                                <td style="text-align: right; border-top: 1px solid #000;">{{ $util->num_f($total_expenses_period2 ?? 0, true, null) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#cash_flows_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#cash_flows_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#cash_flows_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#cash_flows_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#cash_flows_filter_form').on('submit', function() {
            var start_date_val = $('#cash_flows_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#cash_flows_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection

