@extends('layouts.app')
@section('title', __('businessmanagement::lang.balance_sheet'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.balance_sheet') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'balanceSheet']), 'method' => 'get', 'id' => 'balance_sheet_filter_form' ]) !!}
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('start_date', __('businessmanagement::lang.start_date') . ':') !!}
                        @php
                            $start_date_value = '';
                            if (!empty($start_date)) {
                                $start_date_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                            } else {
                                $start_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('start_date_display', $start_date_value, ['class' => 'form-control date-picker', 'id' => 'balance_sheet_start_date', 'readonly']); !!}
                        {!! Form::hidden('start_date', $start_date ?? date('Y-m-d'), ['id' => 'hidden_start_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('end_date', __('businessmanagement::lang.end_date') . ':') !!}
                        @php
                            $end_date_value = '';
                            if (!empty($end_date)) {
                                $end_date_value = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } else {
                                $end_date_value = \Carbon\Carbon::now()->format('d/m/Y');
                            }
                        @endphp
                        {!! Form::text('end_date_display', $end_date_value, ['class' => 'form-control date-picker', 'id' => 'balance_sheet_end_date', 'readonly']); !!}
                        {!! Form::hidden('end_date', $end_date ?? date('Y-m-d'), ['id' => 'hidden_end_date']); !!}
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('businessmanagement::lang.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'balanceSheet']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'printBalanceSheet'], ['start_date' => !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('Y-m-d') : date('Y-m-d'), 'end_date' => !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('Y-m-d') : date('Y-m-d'), 'location_id' => $location_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    <table class="table table-bordered" style="font-size: 12px; width: 100%; border-collapse: collapse; margin: 0;">
                        <thead>
                            <tr>
                                <th colspan="2" style="width: 50%; text-align: center; font-weight: bold; border: 1px solid #000; padding: 8px; background-color: #f5f5f5;">Liabilities</th>
                                <th colspan="2" style="width: 50%; text-align: center; font-weight: bold; border: 1px solid #000; padding: 8px; background-color: #f5f5f5;">Assets</th>
                            </tr>
                            <tr>
                                <th style="width: 35%; text-align: left; font-weight: bold; border: 1px solid #000; padding: 8px; background-color: #f5f5f5;">Name</th>
                                <th style="width: 15%; text-align: right; font-weight: bold; border: 1px solid #000; padding: 8px; background-color: #f5f5f5;">Amount</th>
                                <th style="width: 35%; text-align: left; font-weight: bold; border: 1px solid #000; padding: 8px; background-color: #f5f5f5;">Name</th>
                                <th style="width: 15%; text-align: right; font-weight: bold; border: 1px solid #000; padding: 8px; background-color: #f5f5f5;">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $max_rows = max(count($liabilities), count($assets));
                            @endphp
                            @for($i = 0; $i < $max_rows; $i++)
                                <tr>
                                    <!-- Liabilities Column -->
                                    @if(isset($liabilities[$i]))
                                        @php $liability = $liabilities[$i]; @endphp
                                        <td style="border: 1px solid #000; padding: 5px; vertical-align: top;">
                                            <div style="font-weight: bold;">{{ $liability['label'] }}</div>
                                            @if(!empty($liability['sub_label']))
                                                <div style="font-weight: bold; padding-left: 20px; margin-top: 5px;">{{ $liability['sub_label'] }}</div>
                                            @endif
                                            @foreach($liability['items'] ?? [] as $item)
                                                <div style="padding-left: 40px; margin-top: 3px;">{{ $item['name'] }}</div>
                                            @endforeach
                                        </td>
                                        <td style="border: 1px solid #000; padding: 5px; text-align: right; vertical-align: top;">
                                            <div style="font-weight: bold;">{{ $util->num_f($liability['total'], true, null) }}</div>
                                            @if(!empty($liability['sub_label']))
                                                <div style="margin-top: 5px;">&nbsp;</div>
                                            @endif
                                            @foreach($liability['items'] ?? [] as $item)
                                                <div style="margin-top: 3px;">{{ $util->num_f($item['value'], true, null) }}</div>
                                            @endforeach
                                            @if($i < count($liabilities) - 1 || ($i == count($liabilities) - 1 && $i < count($assets) - 1))
                                                <div style="border-top: 1px solid #000; margin-top: 5px;"></div>
                                            @endif
                                        </td>
                                    @else
                                        <td style="border: 1px solid #000; padding: 5px;">&nbsp;</td>
                                        <td style="border: 1px solid #000; padding: 5px;">&nbsp;</td>
                                    @endif
                                    
                                    <!-- Assets Column -->
                                    @if(isset($assets[$i]))
                                        @php $asset = $assets[$i]; @endphp
                                        <td style="border: 1px solid #000; padding: 5px; vertical-align: top;">
                                            <div style="font-weight: bold;">{{ $asset['label'] }}</div>
                                            @if(!empty($asset['sub_label']))
                                                <div style="font-weight: bold; padding-left: 20px; margin-top: 5px;">{{ $asset['sub_label'] }}</div>
                                            @endif
                                            @foreach($asset['items'] ?? [] as $item)
                                                <div style="padding-left: 40px; margin-top: 3px;">{{ $item['name'] }}</div>
                                            @endforeach
                                        </td>
                                        <td style="border: 1px solid #000; padding: 5px; text-align: right; vertical-align: top;">
                                            <div style="font-weight: bold;">{{ $util->num_f($asset['total'], true, null) }}</div>
                                            @if(!empty($asset['sub_label']))
                                                <div style="margin-top: 5px;">&nbsp;</div>
                                            @endif
                                            @foreach($asset['items'] ?? [] as $item)
                                                <div style="margin-top: 3px;">{{ $util->num_f($item['value'], true, null) }}</div>
                                            @endforeach
                                            @if($i < count($assets) - 1 || ($i == count($assets) - 1 && $i < count($liabilities) - 1))
                                                <div style="border-top: 1px solid #000; margin-top: 5px;"></div>
                                            @endif
                                        </td>
                                    @else
                                        <td style="border: 1px solid #000; padding: 5px;">&nbsp;</td>
                                        <td style="border: 1px solid #000; padding: 5px;">&nbsp;</td>
                                    @endif
                                </tr>
                            @endfor
                        </tbody>
                        <tfoot>
                            <tr style="border-top: 2px double #000; background-color: #f8f9fa;">
                                <td style="font-weight: bold; text-align: right; border-top: 2px double #000; padding: 8px; border-left: 1px solid #000; border-right: 1px solid #000;">Grand Total</td>
                                <td style="text-align: right; font-weight: bold; border-top: 2px double #000; padding: 8px; border-right: 1px solid #000;">{{ $util->num_f($total_liabilities, true, null) }}</td>
                                <td style="font-weight: bold; text-align: right; border-top: 2px double #000; padding: 8px; border-left: 1px solid #000;">Grand Total</td>
                                <td style="text-align: right; font-weight: bold; border-top: 2px double #000; padding: 8px; border-right: 1px solid #000;">{{ $util->num_f($total_assets, true, null) }}</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers
        $('#balance_sheet_start_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#balance_sheet_start_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_start_date').val(formatted_date);
            }
        });

        $('#balance_sheet_end_date').datepicker({
            format: 'dd/mm/yyyy',
            autoclose: true,
            todayHighlight: true,
            orientation: 'bottom auto',
            todayBtn: 'linked',
            clearBtn: false
        });

        $('#balance_sheet_end_date').on('changeDate', function(e) {
            var date_parts = $(this).val().split('/');
            if (date_parts.length == 3) {
                var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                $('#hidden_end_date').val(formatted_date);
            }
        });

        // Ensure hidden date fields are populated before form submission
        $('#balance_sheet_filter_form').on('submit', function() {
            var start_date_val = $('#balance_sheet_start_date').val();
            if (start_date_val) {
                var date_parts = start_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_start_date').val(formatted_date);
                }
            }
            
            var end_date_val = $('#balance_sheet_end_date').val();
            if (end_date_val) {
                var date_parts = end_date_val.split('/');
                if (date_parts.length == 3) {
                    var formatted_date = date_parts[2] + '-' + date_parts[1] + '-' + date_parts[0];
                    $('#hidden_end_date').val(formatted_date);
                }
            }
        });
    });
</script>
@endsection
