<?php

namespace Modules\BusinessManagement\Http\Controllers;

use Illuminate\Routing\Controller;
use Menu;
use App\Utils\ModuleUtil;

class DataController extends Controller
{
    /**
     * Defines user permissions for the module.
     * @return array
     */
    public function user_permissions()
    {
        return [
            [
                'value' => 'businessmanagement.view',
                'label' => __('businessmanagement::lang.view_businessmanagement'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.purchase_register',
                'label' => __('businessmanagement::lang.view_purchase_register'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.sales_register',
                'label' => __('businessmanagement::lang.view_sales_register'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.stock_register',
                'label' => __('businessmanagement::lang.view_stock_register'),
                'default' => false
            ],
            [
                'value' => 'businessmanagement.accounts_register',
                'label' => __('businessmanagement::lang.view_accounts_register'),
                'default' => false
            ],
        ];
    }

    /**
     * Superadmin package permissions
     *
     * @return array
     */
    public function superadmin_package()
    {
        return [
            [
                'name' => 'businessmanagement_module',
                'label' => __('businessmanagement::lang.businessmanagement_module'),
                'default' => false,
            ],
        ];
    }

    /**
     * Modify admin menu to add Business Management menu item
     */
    public function modifyAdminMenu()
    {
        try {
            $module_util = new ModuleUtil();
            $business_id = session()->get('user.business_id');

            // Check if module is enabled in subscription
            if (auth()->user()->can('superadmin')) {
                $is_businessmanagement_enabled = $module_util->isModuleInstalled('BusinessManagement');
            } else {
                $is_businessmanagement_enabled = (bool) $module_util->hasThePermissionInSubscription($business_id, 'businessmanagement_module');
            }

            if (!$is_businessmanagement_enabled) {
                return; // Module not enabled, skip menu modification
            }

            if (auth()->user()->can('businessmanagement.view')) {
                // Business Management dropdown menu
                Menu::instance('admin-sidebar-menu')
                    ->dropdown(
                        __('businessmanagement::lang.business_management'),
                        function ($sub) {
                            // Purchase Register
                            if (auth()->user()->can('businessmanagement.purchase_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.purchase_register'), 
                                    ['active' => request()->routeIs('businessmanagement.purchase_register.index')]
                                );
                                // Date wise Purchase - sub menu under Purchase Register
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchase']), 
                                    __('businessmanagement::lang.date_wise_purchase'), 
                                    ['active' => request()->routeIs('businessmanagement.purchase_register.date_wise')]
                                );
                            }
                            
                            // Sales Register
                            if (auth()->user()->can('businessmanagement.sales_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.sales_register'), 
                                    ['active' => request()->routeIs('businessmanagement.sales_register.*')]
                                );
                            }
                            
                            // Stock Register
                            if (auth()->user()->can('businessmanagement.stock_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\StockRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.stock_register'), 
                                    ['active' => request()->routeIs('businessmanagement.stock_register.*')]
                                );
                            }
                            
                            // Accounts Register
                            if (auth()->user()->can('businessmanagement.accounts_register')) {
                                $sub->url(
                                    action([\Modules\BusinessManagement\Http\Controllers\AccountsRegisterController::class, 'index']), 
                                    __('businessmanagement::lang.accounts_register'), 
                                    ['active' => request()->routeIs('businessmanagement.accounts_register.*')]
                                );
                            }
                        },
                        ['active' => request()->routeIs('businessmanagement.*')]
                    )
                    ->order(85);
            }
        } catch (\Exception $e) {
            \Log::error('BusinessManagement menu modification error: ' . $e->getMessage());
        }
    }
}

